//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Tags Mapper
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
// Contributors: ShiftTheDev, ChosenArchitect
//
// Simple script to map multiple tags to single/multi targets instead of the other way around.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Fixes the inconsistence of fluids tags, such as, oil and xp in #minecraft:water
const fixFluidTags = true;

// Blocks mapped to their needed tags
// - 'block' is the block id, can be an array to apply to multiple
// - 'tags' are the tags to add, needs to be an array
const blockToTags = [
	{
		block: ["minecraft:reinforced_deepslate", "minecraft:trial_spawner", "minecraft:trial_vault", "minecraft:trial_vault_ominous"],
		tags: [
			"forge:mineable/paxel", "minecraft:mineable/mattock", "projecte:mineable/morning_star", 
			"projecte:mineable/hammer", "minecraft:mineable/pickaxe"
		]
	}
	
	// QUICK NOTE: Trial spawners and vaults are allowed to drop in the 'drop_fixes.js' but if they are dropped they will never work again, 
	// the purpose is to be cosmetic, as they are nice for some builds. The tags help getting the right tools to mine them.
];

// Items mapped to their needed tags
// - 'item' is the item id, can be an array to apply to multiple, tags are supported
// - 'tags' are the tags to add, needs to be an array
// - 'deep' copies item by item from the tag ('item') to the tags in 'tags', in that case 'item' should not have the prefixing "#"
const itemToTags = [
	{
		item: "draconicevolution:deepslate_draconium_ore",
		tags: ["forge:ores", "forge:ores/draconium", "balm:ores"]
	},
	{
		item: "gag:time_sand_pouch",
		tags: ["curios:bundle"]
	},
	{
		item: /cyclic:mattock.+/,
		tags: ["forge:tools/mattocks"]
	},
	{
		item: "redstone_arsenal:flux_sickle",
		tags: ["forge:tools/sickles"]
	},
	{
		item: ["refinedstorage:creative_controller", /refinedstorage:.+_creative_controller/],
		tags: ["refinedstorage:creative_controller"]
	},
	{
		item: /rftoolsdim:.+_dimlet/,
		tags: ["rftoolsdim:dimlet"]
	},
	{
		item: /rftoolsdim:empty_.+_dimlet/,
		tags: ["rftoolsdim:empty_dimlet"]
	},
    {
        item: ["mekanism:atomic_disassembler"],
        tags: ["forge:tools", "minecraft:tools", "forge:tools/atomic_disassembler"]
    },
    {
        item: ["mekanism:meka_tool"],
        tags: ["forge:tools", "minecraft:tools", "forge:tools/atomic_disassembler", "forge:tools/meka_tool"]
    },
    {
        item: ["mekanism:atomic_disassembler", "mekanism:meka_tool", /draconicevolution:.+_staff/],
        tags: ["forge:tools", "minecraft:tools", "forge:tools/paxels", "forge:tools/katar", "forge:tools/morning_star"]
    },
    {
        item: [/draconicevolution:.+_pickaxe/, "thermal:flux_drill"],
        tags: ["forge:tools", "minecraft:tools", "forge:tools/pickaxes", "minecraft:pickaxes"]
    },
    {
        item: ["thermal:flux_saw", /draconicevolution:.+_axe/],
        tags: ["forge:tools", "minecraft:tools", "forge:tools/axes", "minecraft:axes"]
    },
    {
        item: [/draconicevolution:.+_shovel/],
        tags: ["forge:tools", "minecraft:tools", "forge:tools/shovels", "minecraft:shovels"]
    },
    {
        item: "forge:storage_blocks/bronze",
        tags: ["pa2_extras:storage_blocks/bronze"],
        deep: true
    },
    {
        item: "forge:storage_blocks/copper",
        tags: ["pa2_extras:storage_blocks/copper"],
        deep: true
    },
    {
        item: "forge:storage_blocks/electrum",
        tags: ["pa2_extras:storage_blocks/electrum"],
        deep: true
    },
    {
        item: "forge:storage_blocks/gold",
        tags: ["pa2_extras:storage_blocks/gold"],
        deep: true
    },
    {
        item: "forge:storage_blocks/invar",
        tags: ["pa2_extras:storage_blocks/invar"],
        deep: true
    },
    {
        item: "forge:storage_blocks/iron",
        tags: ["pa2_extras:storage_blocks/iron"],
        deep: true
    },
    {
        item: "forge:storage_blocks/lead",
        tags: ["pa2_extras:storage_blocks/lead"],
        deep: true
    },
    {
        item: "forge:storage_blocks/nickel",
        tags: ["pa2_extras:storage_blocks/nickel"],
        deep: true
    },
    {
        item: "thermal_extra:zinc_dust",
        tags: ["emc:remove"]
    },
    {
        item: "createdeco:zinc_sheet",
        tags: ["forge:plates/zinc"]
    }
];

// Remaps blocks with a tag to use another tag instead
// - Key is the tag to replace, value the tag to replace with
const replaceBlockTags = {};

// Removes items from a tag
const removeItemsFromTag = [
    {
        tag: "forge:storage_blocks/bronze",
        items: [/chisel_chipped_integration:metal_bronze_.+/, "#chisel_chipped_integration:metals/bronze_blocks"]
    },
    {
        tag: "forge:storage_blocks/copper",
        items: [/chisel_chipped_integration:metal_copper_.+/, "#chisel_chipped_integration:metals/copper_blocks"]
    },
    {
        tag: "forge:storage_blocks/electrum",
        items: [/chisel_chipped_integration:metal_electrum_.+/, "#chisel_chipped_integration:metals/electrum_blocks"]
    },
    {
        tag: "forge:storage_blocks/gold",
        items: [/chisel_chipped_integration:metal_gold_.+/, "#chisel_chipped_integration:metals/gold_blocks"]
    },
    {
        tag: "forge:storage_blocks/invar",
        items: [/chisel_chipped_integration:metal_invar_.+/, "#chisel_chipped_integration:metals/invar_blocks"]
    },
    {
        tag: "forge:storage_blocks/iron",
        items: [/chisel_chipped_integration:metal_iron_.+/, "#chisel_chipped_integration:metals/iron_blocks"]
    },
    {
        tag: "forge:storage_blocks/lead",
        items: [/chisel_chipped_integration:metal_lead_.+/, "#chisel_chipped_integration:metals/lead_blocks"]
    },
    {
        tag: "forge:storage_blocks/nickel",
        items: [/chisel_chipped_integration:metal_nickel_.+/, "#chisel_chipped_integration:metals/nickel_blocks"]
    },
    {
        tag: "minecraft:redstone_ores",
        items: ["regions_unexplored:raw_redstone_block"]
    },
    {
        tag: "forge:ores",
        items: ["regions_unexplored:raw_redstone_block"]
    },
    {
        tag: "forge:ores/redstone",
        items: ["regions_unexplored:raw_redstone_block"]
    }
]

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Applies the tags provided above
ServerEvents.tags("block", event => {
	// Adds tags to blocks
	blockToTags.forEach(entry => {
		entry.tags.forEach(tag => {
			event.add(tag, entry.block);
		});
	});
	
	// Replaces tags in blocks
	Object.keys(replaceBlockTags).forEach(tag => {
		event.get(tag).getObjectIds().forEach(item => {
			event.add(replaceBlockTags[tag], item);
		});
		
		event.removeAll(tag);
	});

    // Fixes Hydroponic Bed
    event.remove("minecraft:dirt", "industrialforegoing:hydroponic_bed");
});

ServerEvents.tags("item", event => {
	// Adds tags to items
	itemToTags.forEach(entry => {
		entry.tags.forEach(tag => {
            if (entry.deep === undefined || entry.deep === false)
			    event.add(tag, entry.item);
            else
            {
                event.get(entry.item).getObjectIds().forEach(item => {
                    event.add(tag, item);
                });
            }
		});
	});

    // Removes items from tags
    removeItemsFromTag.forEach(entry => {
        event.remove(entry.tag, entry.items);
    });
});

ServerEvents.tags("fluid", event => {
	// Applies fluid tag fixes
	if (fixFluidTags)
	{
		event.remove("minecraft:water", /(?!:water)/);
		event.add("minecraft:water", ["minecraft:water", "minecraft:flowing_water"]);
	}
	//event.get("minecraft:water").getObjectIds().forEach(id => console.log(id));
});